/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.seals.network;

import com.buuz135.seals.SealInfo;
import com.buuz135.seals.Seals;
import com.buuz135.seals.network.ClientSyncSealsMessage;
import com.buuz135.seals.network.IMessage;
import com.buuz135.seals.storage.SealWorldStorage;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SealRequestMessage
implements IMessage {
    private ResourceLocation seal;

    public SealRequestMessage(ResourceLocation seal) {
        this.seal = seal;
    }

    public SealRequestMessage() {
    }

    @Override
    public SealRequestMessage fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.seal = packetBuffer.func_192575_l();
        return this;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.func_192572_a(this.seal);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayerEntity entity = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            SealInfo sealInfo = Seals.SEAL_MANAGER.getSeal(this.seal);
            if (sealInfo != null && sealInfo.hasAchievedSeal(entity)) {
                SealWorldStorage.get(entity.func_71121_q()).put(entity.func_110124_au(), this.seal);
                CompoundNBT data = SealWorldStorage.get(entity.func_71121_q()).serializeNBT();
                entity.func_71121_q().func_217369_A().forEach(entity1 -> Seals.NETWORK.sendTo((Object)new ClientSyncSealsMessage(data), entity1.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

